function [Mee,Nee] = solution_getmatrices_ee(GLOBALS,THETA,xss,yss,sss,Pss,H,G,G2)
%#ok<*AGROW>

% -- Other Setup -- %
E = exp(1);
ny = GLOBALS.ny;
nx = GLOBALS.nx;
ne = GLOBALS.ne;
n = nx + ny;
ns = GLOBALS.ns;
Mee = cell(ns,ns);
Nee = cell(ns,ns);

% -- Load Calibrated Parameters -- %
bbeta           = GLOBALS.parameters.bbeta;
rrho            = GLOBALS.parameters.rrho;
aalpha          = GLOBALS.parameters.aalpha;
eeta            = GLOBALS.parameters.eeta;
ddelta          = GLOBALS.parameters.ddelta;
oomega          = GLOBALS.parameters.oomega;
ebar            = GLOBALS.parameters.ebar;
pbar            = GLOBALS.parameters.pbar;
abar            = GLOBALS.parameters.abar;
zbar            = GLOBALS.parameters.zbar;
varphi(1)       = GLOBALS.parameters.varphi0;
varphi(2)       = GLOBALS.parameters.varphi1;
nnu(1)          = GLOBALS.parameters.nnu0;
nnu(2)          = GLOBALS.parameters.nnu1;

% -- Load Estimated Parameters -- %
iiota           = THETA(GLOBALS.parm_ind.iiota);
pphi            = THETA(GLOBALS.parm_ind.pphi);
rbar            = THETA(GLOBALS.parm_ind.rbar);
rrhoa           = THETA(GLOBALS.parm_ind.rrhoa);
rrhoz           = THETA(GLOBALS.parm_ind.rrhoz);
rrhop           = THETA(GLOBALS.parm_ind.rrhop);
rrhor           = THETA(GLOBALS.parm_ind.rrhor);
rrhoe           = THETA(GLOBALS.parm_ind.rrhoe);
rrhod           = THETA(GLOBALS.parm_ind.rrhod);
ssigmaa       = THETA(GLOBALS.parm_ind.ssigmaa);
ssigmaz       = THETA(GLOBALS.parm_ind.ssigmaz);
ssigmap       = THETA(GLOBALS.parm_ind.ssigmap);
ssigmar       = THETA(GLOBALS.parm_ind.ssigmar);
ssigmae       = THETA(GLOBALS.parm_ind.ssigmae);
ssigmad       = THETA(GLOBALS.parm_ind.ssigmad);

% Load Estimated or Calibrated Parameters -- %
try
    kkappa          = THETA(GLOBALS.parm_ind.kkappa);
    ppsir           = GLOBALS.parameters.ppsir;
    bbar            = GLOBALS.parameters.bbar;
catch
    kkappa          = GLOBALS.parameters.kkappa;
    ppsir           = THETA(GLOBALS.parm_ind.ppsir);
    bbar            = THETA(GLOBALS.parm_ind.bbar);
end
try
    ggamma00        = log(GLOBALS.parameters.p01/(1-GLOBALS.parameters.p01));
    ggamma10        = log(GLOBALS.parameters.p10/(1-GLOBALS.parameters.p10));
catch
    ggamma00        = log(THETA(GLOBALS.parm_ind.p01)/(1-THETA(GLOBALS.parm_ind.p01)));
    ggamma10        = log(THETA(GLOBALS.parm_ind.p10)/(1-THETA(GLOBALS.parm_ind.p10)));
end

try
    ggamma01        = exp(THETA(GLOBALS.parm_ind.loggamma01));
    ggamma11        = exp(THETA(GLOBALS.parm_ind.loggamma11));
catch
    ggamma01        = exp(GLOBALS.parameters.loggamma01);
    ggamma11        = exp(GLOBALS.parameters.loggamma11);
end

% -- Perturbation Point -- %
varphibar   = varphi*sss;
param = [bbeta, rrho, oomega, eeta, aalpha, ddelta, pbar, ebar, iiota, pphi, rbar, kkappa, rrhoa, rrhoz, rrhop, rrhor, rrhoe, rrhod, varphibar, bbar, ppsir, abar, zbar, ssigmaa, ssigmaz, ssigmap, ssigmar, ssigmae, ssigmad];

% -- Derivative of Transition Matrix -- %
dP1   = zeros(2,2);
dP2   = zeros(2,2);
dP1(1,1) =  exp(ggamma00+ggamma01*yss(11))*ggamma01/(exp(ggamma00)+exp(ggamma01*yss(11)))^2;
dP1(1,2) = -exp(ggamma00+ggamma01*yss(11))*ggamma01/(exp(ggamma00)+exp(ggamma01*yss(11)))^2;
dP2(2,1) = -exp(ggamma10+ggamma11*yss(10))*ggamma11/(exp(ggamma10)+exp(ggamma11*yss(10)))^2;
dP2(2,2) =  exp(ggamma10+ggamma11*yss(10))*ggamma11/(exp(ggamma10)+exp(ggamma11*yss(10)))^2;

for s = 1:ns
    for sp = 1:ns
        [Mee{sp,s}, Nee{sp,s}] = mex_getmatrices_ee(n,ny,ne,xss,yss,param,nnu(s),H{s},G{s},G{sp},G2{sp},Pss(s,sp),dP1(s,sp),dP2(s,sp));  
    end
end